<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Tymon\JWTAuth\Exceptions\JWTException;
use Throwable;

class Handler extends ExceptionHandler
{
    /**
     * A list of the exception types that are not reported.
     *
     * @var array<int, class-string<Throwable>>
     */
    protected $dontReport = [
        //
    ];

    /**
     * A list of the inputs that are never flashed for validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     *
     * @return void
     */
    public function register()
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

    public function render($request, Throwable $exception)
    {
        if ($exception instanceof JWTException && $request->expectsJson()) {
            return response()->json(['status_code'=>'58','status_desc' => 'Authentication failed (invalid token)'], 401);
        }

        if ($exception instanceof \Illuminate\Database\QueryException) {
            $message = $exception->getMessage();
            return response()->json(['status_code' => '94', 'status_desc' => 'Duplicate transaction ( RequestID)'], 500);

            // \Log::error('Database Error: ' . $exception->getMessage());

            // // Optional: Include the error message in the response for testing purposes
            // return response()->json([
            //     'status_code' => '94',
            //     'status_desc' => 'Duplicate transaction ( RequestID)',
            //     'error' => $exception->getMessage() // Debug only, remove in production
            // ], 500);
        }

        return parent::render($request, $exception);
    }
}
