<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Tymon\JWTAuth\Facades\JWTAuth;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;
use App\Models\CachedUser;


class UserController extends Controller
{
    private $http_headers;
    private $url;

    public function __construct()
    {
        $this->http_headers = [
            'Authorization' => env('EB_AUTHORIZATION'),
            'Accept' => env('EB_ACCEPT'),
            'api_key' => env('EB_API_KEY'),
            'eBanqr-Platform-TenantID' => env('EB_TENANTID'),
        ];
        $this->url = env('EB_URL');
    }

    public function user($account_id)
    {
        $token = JWTAuth::parseToken();
        $user = $token->authenticate();

        if ($user->api_token_status === 0) {
            return response()->json(['status' => 'error', 'message' => 'Token is disabled',], 403);
        }

        $account_id = str_replace("NT", "", strtoupper($account_id));

        $response = Http::withHeaders(
            $this->http_headers
        )->get("{$this->url}/savingsaccounts/{$account_id}");

        if ($response->ok()) {

            $data = json_decode($response);

            return response()->json(
                [
                    'status' => 'success',
                    'name' => $data->clientName,
                    'accountNumber' => "NT" . $data->accountNo,
                    'message' => 'Success',
                ],
                200
            );
        } else {

            return response()->json(['status' => 'error', 'message' => 'User not found',], 404);
        }
    }

    public function flexipay(Request $request)
    {
        #get agent making the api call
        $user = $request->user;

        #check if the agent is diactivated
        if ($user->api_token_status === 0) {
            return response()->json(['status_code' => '58', 'status_desc' => 'Authentication failed (Token is disabled)',], 403);
        }

        #validate that the customer field exits
        $validator = Validator::make($request->all(), [
            'customer_number' => 'required',
        ]);

        #if the validation faile return an error
        if ($validator->fails()) {
            return  response()->json(['status_code' => '58', 'status_desc' => 'Invalid Client ID', 'errors' => $validator->errors()], 400);
        }

        #prepare a response to return
        $response = [
            'status_code' => '00',
            'status_desc' => 'Completed successfully',
            'pending_balance' => 0,
            'payment_mod' => 'FULL',
        ];

        #clean the account id
        $account_id = str_replace("NT", "", strtoupper($request['customer_number']));

        #query to check if the the account is cached
        $cached_user = CachedUser::where('account_number', '=', $account_id)->first();

        #if the account is cached and has a phone number
        if ($cached_user && !empty($cached_user->phone) ) {
            $response['customer_name'] = $cached_user->name;

            return response()->json($response, 200);

        } else { #if account is not cached

            #make a request to ebanqr to get the account details
            $http_response = Http::withHeaders($this->http_headers)
                ->get("{$this->url}/savingsaccounts/{$account_id}");

            #if the response is successfull
            if ($http_response->ok()) {

                #decode the json data
                $data = json_decode($http_response);

                #check if the account was cached. if it was not cached. create a new account
                if(empty($cached_user))
                {
                    $cached_user = new CachedUser();
                }
                
                #set the account number and name
                $cached_user->account_number = $account_id;
                $cached_user->name = $data->clientName;

                #check if the clientId exists and set it
                if(isset($data->clientId))
                {
                    $cached_user->client_id = $data->clientId;
                }
               
                #save the account
                $cached_user->save();

                #set the response name to return to the user
                $response['customer_name'] = $data->clientName;

                #return a response
                return response()->json($response, 200);

            } else {
                #return failure response
                return response()->json(['status_code' => '58', 'status_desc' => 'Invalid Client ID',], 404);
            }
        }
    }
}
