<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\APITransaction;
use Illuminate\Support\Facades\Auth;

class APITransactionController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $user = Auth::user();
        $module = "APITransaction";

        $APITransactions = APITransaction::orderBy('API_timestamp','desc')
            ->where(function ($query) {

                if ($search = request()->query('search')) {

                    $query->where("payment_agent", "LIKE", "%{$search}%");
                    $query->orWhere("accountNumber", "LIKE", "%{$search}%");
                    $query->orWhere("name", "LIKE", "%{$search}%");
                    $query->orWhere("phoneNumber", "LIKE", "%{$search}%");
                }
            })
            ->paginate(50);

        return view('api_transaction.index', compact('user', 'module', 'APITransactions'));
    }

    public function requeue_transaction(Request $request,$id){
        
        $transaction = APITransaction::findOrFail($id);

        $transaction->sync = 'EB_SYNC_PENDING';
        $transaction->comment='';

        $transaction->save();

        return redirect()->route('APITransaction.index')->with('success', 'Transaction successfully requeued!');

    }
}
