<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\APITransaction;
use Illuminate\Support\Facades\DB;


class DashboardController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $user = Auth::user();
        $this->authorize('administration', $user);
        $module = "Dashboard";

        $week_account = $this->format_data($this->transaction_agg_account(7, 'DAY','cached_users.name'),'name');
        $month_account = $this->format_data($this->transaction_agg_account(1, 'MONTH','cached_users.name'),'name');
        $quarter_account = $this->format_data($this->transaction_agg_account(3, 'MONTH','cached_users.name'),'name');

        $week_agent = $this->format_data($this->transaction_agg_agent(7, 'DAY', 'payment_agent'),'payment_agent');
        $month_agent = $this->format_data($this->transaction_agg_agent(1, 'MONTH', 'payment_agent'),'payment_agent');
        $quarter_agent = $this->format_data($this->transaction_agg_agent(3, 'MONTH', 'payment_agent'),'payment_agent');

        return view('dashboard.index', compact(
            'user',
            'module',
            'week_account',
            'month_account',
            'quarter_account',
            'week_agent',
            'month_agent',
            'quarter_agent',
        ));
    }

    private function transaction_agg_agent($interval = 7, $unit = 'DAY', $agg_column = 'accountNumber')
    {
        return APITransaction::select($agg_column, DB::raw('SUM(transactionAmount) as amount'))
            ->where('API_timestamp', '>=', DB::raw("DATE_SUB(now(), INTERVAL {$interval} {$unit})"))
            ->groupBy($agg_column)
            ->orderByDesc('amount')
            ->limit(5)
            ->get();
    }

    private function transaction_agg_account($interval = 7, $unit = 'DAY', $agg_column = 'accountNumber')
    {
        return APITransaction::select($agg_column, DB::raw('SUM(transactionAmount) as amount'))
            ->join('cached_users', 'cached_users.account_number', '=', 'api_transactions.accountNumber')
            ->where('API_timestamp', '>=', DB::raw("DATE_SUB(now(), INTERVAL {$interval} {$unit})"))
            ->groupBy($agg_column)
            ->orderByDesc('amount')
            ->limit(7)
            ->get();
    }

    private function format_data($info, $agg_column = 'accountNumber')
    {
        $labels = "";
        $data = "";

        foreach ($info as $I) {
            $labels .= "'".trim($I->$agg_column,'0')."',";
            $data .= "{$I->amount},";
        }

        return ['labels' => "[" . trim($labels, ',') . "]", 'data' => "[" . trim($data, ',') . "]"];
    }
}
