<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Enums\Role;
use Illuminate\Support\Facades\Hash;
use Tymon\JWTAuth\Facades\JWTAuth;

class PaymentAgentController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $user = Auth::user();
        $this->authorize('administration',$user);
        $module = "PaymentAgents";

        $payment_agents = User::where('role',Role::PaymentAgent)->orderBy('created_at','desc')->get();

        return view('payment_agent.index', compact('user','module','payment_agents'));
    }


    public function create(){
        
        $user = Auth::user();
        $this->authorize('administration',$user);
        $module = "PaymentAgents";

        $user_model = new User();

        return view('payment_agent.add_payment_agent', compact('user','module','user_model'));
    }

    public function store(Request $request){

        $this->authorize('administration',Auth::user());

        $request->validate([
            'name' =>'required',
            'email' =>'required|email',
            'api_token_status' => 'required|integer',
            'environment' => 'required',
        ]);

        $user_model = User::create([
            'name' => $request['name'],
            'email' => $request['email'],
            'api_token_status'=>$request['api_token_status'],
            'environment'=>$request['environment'],
            'password' => Hash::make('p$gj6GvLC'),
        ]);

        $token = JWTAuth::claims(['exp' => now()->addYears(10)->timestamp])
                ->fromUser($user_model);

        $user_model->api_token = $token;
        $user_model->role = Role::PaymentAgent;
        $user_model->save();

        return redirect()->route('payment_agent.index')->with('success', 'User successfully created!');
    }

    public function edit(Request $request,$id){
        $user = Auth::user();
        $this->authorize('administration',$user);

        $module = "PaymentAgents";

        $user_model = User::findOrFail($id);
        return view('payment_agent.edit_payment_agent', compact('user','id','module','user_model'));
    }

    public function update(Request $request, $id){

        $this->authorize('administration',Auth::user());

        $user_model = User::findOrFail($id);

        $request->validate([
            'name' =>'required',
            'email' =>'required|email',
            'api_token_status' => 'required|integer',
            'environment' => 'required',
        ]);

        $user_model->name = $request->input('name');
        $user_model->email = $request->input('email');
        $user_model->api_token_status = $request->input('api_token_status');
        $user_model->environment = $request->input('environment');

        $user_model->save();

        return redirect()->route('payment_agent.index')->with('success', 'Payment Agent successfully updated!');
    }

    public function destroy($id)
    {
        $this->authorize('administration',Auth::user());

        $user_model = User::findOrFail($id);
        $user_model->delete();
        return redirect()->route('payment_agent.index')->with('success','Payment Agent successfully Deleted');
    }

}
