<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Enums\Role;
use ReflectionClass;

class UserController extends Controller
{

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    public function index()
    {
        $user = Auth::user();
        $this->authorize('administration', $user);
        $module = "UserManagement";

        $users = User::where('role', '!=', Role::PaymentAgent)
            ->where(function ($query) {

                if($search = request()->query('search')){

                    $query->where("name","LIKE","%{$search}%");
                    $query->orWhere("account","LIKE","%{$search}%");
                    $query->orWhere("email","LIKE","%{$search}%");
                }
            })
            ->orderBy('created_at', 'desc')->paginate(50);

        return view('user_management.index', compact('user', 'module', 'users'));
    }

    public function edit(Request $request, $id)
    {
        $user = Auth::user();
        $this->authorize('administration', $user);

        $module = "UserManagement";

        $reflectionClass = new ReflectionClass(Role::class);
        $roles = $reflectionClass->getConstants();

        $user_model = User::findOrFail($id);
        return view('user_management.edit_user', compact('user', 'id', 'module', 'user_model', 'roles'));
    }

    public function update(Request $request, $id)
    {

        $this->authorize('administration', Auth::user());

        $user_model = User::findOrFail($id);

        $request->validate([
            'is_active' => 'required',
            'role' => 'required',
            'gender' => 'required',
        ]);

        $user_model->is_active = $request->input('is_active');
        $user_model->role = $request->input('role');
        $user_model->gender = $request->input('gender');

        $user_model->save();

        return redirect()->route('user.index')->with('success', 'User successfully updated!');
    }
}
