<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CachedUser extends Model
{
    use HasFactory;

    protected $fillable =[
        'account_number',
        'name',
        'phone',
        'client_id',
    ];

    public function APITransaction(){
        return $this->hasMany(APITransaction::class, 'accountNumber','account_number');
    }
}
