<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Loan extends Model
{
    use HasFactory;
    protected $fillable = ['loan_product_name','user_id','loan_amount', 'loan_purpose', 'security_offered', 'status', 'comment','interval', 'loan_product', 'max_approval_level','loan_term','number_of_repayments','repayment_frequency','loan_classification','linked_account','standing_instruction','is_top_up','first_repayment_date'];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function approvalRecords()
    {
        return $this->hasMany(ApprovalRecord::class, 'loan_id');
    }

}
