<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPhoneNumberAndClientIdToEbankingActivationRequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ebanking_activation_requests', function (Blueprint $table) {
            //
            $table->string('client_id')->after('account')->nullable()->default(null);
            $table->string('phone_number')->after('date_of_birth')->nullable()->default(null);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ebanking_activation_requests', function (Blueprint $table) {
            $table->dropColumn('phone_number');
            $table->dropColumn('client_id');
        });
    }
}
