<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddUserDetailsToEbankingActivationRequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ebanking_activation_requests', function (Blueprint $table) {
            $table->string('work_address')->after('national_id_number')->nullable()->default(null);
            $table->string('residential_address')->after('work_address')->nullable()->default(null);
            $table->string('marital_status')->after('residential_address')->nullable()->default(null);
            $table->string('spouse_name')->after('marital_status')->nullable()->default(null);
            $table->string('spouse_phone')->after('spouse_name')->nullable()->default(null);
            $table->string('nok_name')->after('spouse_phone')->nullable()->default(null);
            $table->string('nok_phone')->after('nok_name')->nullable()->default(null);
            $table->string('occupation')->after('nok_phone')->nullable()->default(null);
            $table->string('source_of_income')->after('occupation')->nullable()->default(null);
            $table->string('email')->after('source_of_income')->nullable()->default(null);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ebanking_activation_requests', function (Blueprint $table) {
            $table->dropColumn('work_address');
            $table->dropColumn('residential_address');
            $table->dropColumn('marital_status');
            $table->dropColumn('spouse_name');
            $table->dropColumn('spouse_phone');
            $table->dropColumn('nok_name');
            $table->dropColumn('nok_phone');
            $table->dropColumn('occupation');
            $table->dropColumn('source_of_income');
            $table->dropColumn('email');
        });
    }
}
