<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateLoansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('loans', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete(false);
            $table->decimal('loan_amount', 20, 2);
            $table->string('interval');
            $table->string('loan_purpose');
            $table->string('loan_product');
            $table->string('security_offered');
            $table->unsignedTinyInteger('approval_level')->default(1);
            $table->unsignedTinyInteger('max_approval_level');
            $table->string('comment')->nullable();
            $table->enum('status', ['pending', 'rejected', 'approved'])->default('pending');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('loans');
    }
}
