<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateApprovalRecordsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('approval_records', function (Blueprint $table) {
            $table->id();
            $table->foreignId('loan_id')->constrained(); // Assuming you have a "loans" table
            $table->foreignId('user_id')->constrained()->cascadeOnDelete(false);
            $table->unsignedDecimal('adjusted_amount', 20, 2)->nullable();
            $table->unsignedTinyInteger('approval_level');
            $table->text('comments')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('approval_records');
    }
}
