<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class MakeFieldsNullableInLoansTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('loans', function (Blueprint $table) {
            $table->string('loan_amount')->nullable()->change();
            $table->string('interval')->nullable()->change();
            $table->string('loan_purpose')->nullable()->change();
            $table->string('loan_product')->nullable()->change();
            $table->string('security_offered')->nullable()->change();
            $table->string('approval_level')->nullable()->change();
            $table->string('max_approval_level')->nullable()->change();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('loans', function (Blueprint $table) {
            $table->string('loan_amount')->nullable(false)->change();
            $table->string('interval')->nullable(false)->change();
            $table->string('loan_purpose')->nullable(false)->change();
            $table->string('loan_product')->nullable(false)->change();
            $table->string('security_offered')->nullable(false)->change();
            $table->string('approval_level')->nullable(false)->change();
            $table->string('max_approval_level')->nullable(false)->change();
        });
    }
}
