<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddCollateralIdAndSyncToLoanCollateralTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('loan_collateral', function (Blueprint $table) {
            $table->integer('collateral_id')->nullable()->after('description');
            $table->tinyInteger('sync')->default(0)->after('collateral_id');
            $table->string('collateral_name')->nullable()->after('collateral_type');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('loan_collateral', function (Blueprint $table) {
            $table->dropColumn('collateral_id');
            $table->dropColumn('sync');
            $table->dropColumn('collateral_name');
        });
    }
}
