<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddColumnsToLoanGuarantors extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('loan_guarantors', function (Blueprint $table) {
            $table->unsignedInteger('guarantor_type_id')->nullable()->after('phone_number');
            $table->unsignedInteger('client_relationship_type_id')->nullable()->after('guarantor_type_id');
            $table->unsignedInteger('client_id')->nullable()->after('client_relationship_type_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('loan_guarantors', function (Blueprint $table) {
            $table->dropColumn('guarantor_type_id');
            $table->dropColumn('client_relationship_type_id');
        });
    }
}
