@extends('layouts.logged_out')

@section('content')
    <div class="text-center">
        <img src="{{ asset('img/logo/nzurilogo.png') }}" class="img-thumbnail rounded" alt="Nzuri logo" />
    </div>
    <br>
    <div class="card">

        <div class="card-body">
            <div class="m-sm-4">

                <div class="d-flex justify-content-center">
                    <h5 class="card-title">Reset Password</h5>
                </div>

                @if (session('status'))
                    <div class="alert alert-success" role="alert">
                        {{ session('status') }}
                    </div>
                @endif
                <form method="POST" action="{{ route('password.email') }}">
                    @csrf
                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input class="form-control form-control-lg @error('email') is-invalid @enderror"
                            value="{{ old('email') }}" type="email" name="email" placeholder="Enter your email" />
                        @error('email')
                            <div class="invalid-feedback"> {{ $message }}</div>
                        @enderror
                    </div>
                    <div class="text-center mt-3">
                        <button type="submit" class="btn btn-lg btn-primary">Send Password Reset Link</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
