@extends('layouts.logged_out')

@section('content')
    <div class="text-center">
        <img src="{{ asset('img/logo/nzurilogo.png') }}" class="img-thumbnail rounded" alt="Nzuri logo" />
    </div>
    <br>
    <div class="card">

        <div class="card-body">
            <div class="m-sm-4">

                <div class="d-flex justify-content-center">
                    <h5 class="card-title">Reset Password</h5>
                </div>

                @if (session('status'))
                    <div class="alert alert-success" role="alert">
                        {{ session('status') }}
                    </div>
                @endif
                <form method="POST" action="{{ route('password.update') }}">
                    @csrf
                    <input type="hidden" name="token" value="{{ $token }}">

                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input class="form-control form-control-lg @error('email') is-invalid @enderror"
                            value="{{ $email ?? old('email') }}" required autocomplete="email" autofocus type="email"
                            name="email" />
                        @error('email')
                            <div class="invalid-feedback"> {{ $message }}</div>
                        @enderror
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Password</label>

                        <input id="password" type="password"
                            class="form-control form-control-lg @error('password') is-invalid @enderror" name="password"
                            required placeholder="Enter password" autocomplete="new-password">

                        @error('password')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Confirm Password</label>

                        <input id="password-confirm" type="password"
                            class="form-control form-control-lg @error('password') is-invalid @enderror"
                            name="password_confirmation" required placeholder="Enter confirm password"
                            autocomplete="new-password">

                        @error('password_confirmation')
                            <span class="invalid-feedback" role="alert">
                                <strong>{{ $message }}</strong>
                            </span>
                        @enderror
                    </div>
                    <div class="text-center mt-3">
                        <button type="submit" class="btn btn-lg btn-primary">Reset Password</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
