@extends('layouts.logged_out')

@section('content')
    <div class="text-center">
        <img src="{{ asset('img/logo/nzurilogo.png') }}" class="img-thumbnail rounded" alt="Nzuri logo" />
    </div>
    <br>
    <div class="card">

        <div class="card-body">
            <div class="m-sm-4">
                @if (session('status'))
                    <div class="alert alert-danger">
                        {{ session('status') }}
                    </div>
                @endif
                <div class="d-flex justify-content-center">
                    <h5 class="card-title">Welcome to E-Banking Activation</h5>
                </div>
                <form method="POST" action="{{ route('verify_account_number') }}">
                    @csrf
                    <div class="mb-3">
                        <label class="form-label">Account Number</label>
                        <input class="form-control form-control-lg @error("account") is-invalid @enderror"
                            name="account" value="{{ request()->old("account") }}" type="text"
                            placeholder="Enter your Account Number" />
                        @error("account")
                            <div class="invalid-feedback"> {{ $message }}</div>
                        @enderror
                    </div>

                    <div class="text-center mt-3">
                        <button type="submit" class="btn btn-lg btn-primary">Validate</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
