@extends('layouts.logged_in')

@section('title', 'Loan Charges')

@section('heading', 'Loan charges')

@section('content')
    @include('partials._messages')

    @can('add-loan-charge', $user)
        <a class="btn btn-secondary" href="{{ route('loan_application.loan_charges_create') }}">Create A Loan Charge</a>
    @endcan

    <hr>
    <table class="table">
        <thead>
        <tr>
            <th>Product Name</th>
            <th>Loan Charge</th>
            <th></th>
        </tr>
        </thead>
        <tbody>
        @if(count($charges_to_view) !== 0)
            @foreach($charges_to_view as $c)
                <tr>
                    <td>{{$c['product_name']}}</td>
                    <td>{{$c['charge_name']}}</td>
                </tr>
            @endforeach
        @endif
        </tbody>
    </table>


    <script></script>
@endsection
