@extends('layouts.logged_in')

@section('title', 'Loans Administration')

@section('heading', 'Loans Administration')

@section('content')
    @include('partials._messages')

    <div class="mt-5">
        <ul class="nav nav-tabs full-width-tabs" id="myTabs">
            <li class="nav-item">
                <a class="nav-link active" id="tab1" data-bs-toggle="tab" href="#content1">View Pending Loans</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="tab2" data-bs-toggle="tab" href="#content2">View All Loans</a>
            </li>
            <!-- Add more tabs as needed -->
        </ul>

        <div class="tab-content mt-2">
            <div class="tab-pane fade show active" id="content1">
                <table class="table">
                    <thead>
                    <tr>
                        <th>Loan Amount</th>
                        <th>Loan Period</th>
                        <th>Loan Purpose</th>
                        <th>Loan Product</th>
                        <th>Security Offered</th>
                        <th>comments</th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($loans as $loan)
                        <tr>
                            <td class="text-end">{{number_format($loan->loan_amount, 2, '.', ',')}}</td>
                            <td>{{$loan->interval}}</td>
                            <td>{{ucfirst(str_replace('_', ' ', $loan->loan_purpose))}}</td>
                            <td>{{ucfirst(str_replace('_', ' ', $loan->loan_product))}}</td>
                            <td>{{ucfirst($loan->security_offered)}}</td>
                            <td>
                                <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#approvalRecordsModal{{ $loan->id }}">
                                    View Comments
                                </button>
                            </td>
                            <td>
                                <span class="badge @if ($loan->status == 'pending') bg-warning @elseif ($loan->status == 'approved') bg-success @elseif ($loan->status == 'rejected') bg-danger @endif">{{ ucfirst($loan->status) }}</span>
                            </td>
                            <th>
                                @if ($loan->status == 'pending')
                                    <button type="button" class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#approvalModal{{ $loan->id }}">
                                        Approve Loan
                                    </button>
                                @endif
                                @if ($loan->status == 'pending')
                                    <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#rejectModal{{ $loan->id }}">
                                        Reject Loan
                                    </button>

                                    <div class="modal fade" id="rejectModal{{ $loan->id }}" tabindex="-1" aria-labelledby="rejectModalLabel{{ $loan->id }}" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="rejectModalLabel{{ $loan->id }}">Reject Loan</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <form method="POST" action="{{ route('loan_application.reject', ['loan' => $loan->id]) }}">
                                                        @csrf
                                                        @method('PUT')
                                                        <div class="mb-3">
                                                            <label for="comment">Rejection Comment:</label>
                                                            <textarea name="comment" class="form-control" required></textarea>
                                                        </div>
                                                        <button type="submit" class="btn btn-danger">Reject Loan</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="modal fade" id="approvalModal{{ $loan->id }}" tabindex="-1" aria-labelledby="approvalModalLabel{{ $loan->id }}" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="approvalModalLabel{{ $loan->id }}">Approve Loan</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <form method="POST" action="{{ route('loan_application.approve', ['loan' => $loan->id]) }}">
                                                        @csrf
                                                        @method('PUT')
                                                        <div class="mb-3">
                                                            <label for="comment">Amount</label>
                                                            <input name="amount" class="form-control" type="number" value="{{ $loan->loan_amount }}" max="{{ $loan->loan_amount }}" required />
                                                        </div>
                                                        <div class="mb-3">
                                                            <label for="comment">Approval Comment:</label>
                                                            <textarea name="comment" class="form-control" required></textarea>
                                                        </div>
                                                        <button type="submit" class="btn btn-success">Approve Loan</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endif
                            </th>
                        </tr>
                        <div class="modal fade" id="approvalRecordsModal{{ $loan->id }}" tabindex="-1" aria-labelledby="approvalRecordsModalLabel{{ $loan->id }}" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="approvalRecordsModalLabel{{ $loan->id }}">Approval Records for Loan {{ $loan->loan_amount }}</h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        @php
                                            $approvalRecords = DB::table('approval_records')->where('loan_id', '=', $loan->id )->get();
                                        @endphp
                                        @foreach($approvalRecords as $approvalRecord)
                                            <!-- Display each approval record details here -->
{{--                                            <p>Approver: {{ $approvalRecord->user->name }}</p>--}}
                                            <p>Approval Level: {{$approvalRecord->approval_level}}</p>
                                            <p>Adjusted Amount: {{ $approvalRecord->adjusted_amount }}</p>
                                            <p>Comments: {{ $approvalRecord->comments }}</p>
                                            <!-- Add more details as needed -->
                                            <hr>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                    </tbody>
                </table>
            </div>
            <div class="tab-pane fade" id="content2">
                <table class="table">
                    <thead>
                    <tr>
                        <th>Loan Amount</th>
                        <th>Loan Period</th>
                        <th>Loan Purpose</th>
                        <th>Loan Product</th>
                        <th>Security Offered</th>
                        <th>comments</th>
                        <th>Status</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($allLoans as $loan)
                        <tr>
                            <td class="text-end">{{number_format($loan->loan_amount, 2, '.', ',')}}</td>
                            <td>{{$loan->interval}}</td>
                            <td>{{ucfirst(str_replace('_', ' ', $loan->loan_purpose))}}</td>
                            <td>{{ucfirst(str_replace('_', ' ', $loan->loan_product))}}</td>
                            <td>{{ucfirst($loan->security_offered)}}</td>
                            <td>
                                <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#approvalRecordsAllModal{{ $loan->id }}">
                                    View Comments
                                </button>
                            </td>
                            <td>
                                <span class="badge @if ($loan->status == 'pending') bg-warning @elseif ($loan->status == 'approved') bg-success @elseif ($loan->status == 'rejected') bg-danger @endif">{{ ucfirst($loan->status) }}</span>
                            </td>
                        </tr>
                        <div class="modal fade" id="approvalRecordsAllModal{{ $loan->id }}" tabindex="-1" aria-labelledby="approvalRecordsAllModalLabel{{ $loan->id }}" aria-hidden="true">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title" id="approvalRecordsAllModalLabel{{ $loan->id }}">Approval Records for Loan {{number_format($loan->loan_amount, 2, '.', ',')}} </h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body">
                                        @php
                                            $approvalRecords = DB::table('approval_records')->where('loan_id', '=', $loan->id )->get();
                                        @endphp
                                        @foreach($approvalRecords as $record)
{{--                                            <!-- Display each approval record details here -->--}}
{{--                                            <p>Approver: {{ $record->user->name }}</p>--}}
                                            <p>Approval Level: {{$record->approval_level}}</p>
                                            <p>Adjusted Amount: {{ $record->adjusted_amount }}</p>
                                            <p>Comments: {{ $record->comments }}</p>
{{--                                            <!-- Add more details as needed -->--}}
                                            <hr>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                    </tbody>
                </table>
            </div>
            <!-- Add more content panes as needed -->
        </div>
    </div>
@endsection

<style>
    /* Custom styles for full-width tabs */
    .full-width-tabs .nav-item {
        flex: 1;
        text-align: center;
    }
</style>

