@extends('layouts.logged_in')

@section('title', 'Loan Application')

@section('heading', $user->name. ' / '. 'New Loan Application'. ' ['.  str_replace('_', ' ', $loan->loan_product_name) . ' - '. $loan->interval . ' ]')

@section('content')
    @include('partials._messages')
    <table class="table">
        <thead>
        <tr>
            <th>#</th>
            <th>Date</th>
            <th>Principle Due</th>
            <th>Principle Balance</th>
            <th>Interest & Charges</th>
            <th>Out standing</th>
        </tr>
        </thead>
        <tbody>
        <!-- Loop through loan schedule data and display rows -->
        @foreach ($loan_schedule as $k => $A)
            <tr>
                <td>{{$k + 1}}</td>
                <td>{{ \Carbon\Carbon::create($A['dueDate'][0], $A['dueDate'][1], $A['dueDate'][2])->format('d M Y') }}</td>
                <td>{{$currency}}{{isset($A['principalDue']) ? $A['principalDue'] : ''}}</td>
                <td>{{$currency}}{{isset($A['principalLoanBalanceOutstanding']) ? $A['principalLoanBalanceOutstanding'] : ''}}</td>
                <td>{{$currency}}{{isset($A['totalActualCostOfLoanForPeriod']) ? $A['totalActualCostOfLoanForPeriod'] : ''}}</td>
                <td>{{$currency}}{{isset($A['totalOutstandingForPeriod']) ? $A['totalOutstandingForPeriod'] : ''}}</td>
            </tr>
        @endforeach
        </tbody>
        <tr>
            <td></td>
            <td><b>Total</b></td>
            <td><b>{{$currency}}{{$total_principle}}</b></td>
            <td></td>
            <td><b>{{$currency}}{{$total_interests}}</b></td>
            <td><b>{{$currency}}{{$expected_amount}}</b></td>
        </tr>
    </table>
    <div class="d-flex justify-content-end">
        <a href="{{ route('guarantor.index', compact('loan_id')) }}" class="btn btn-secondary">Previous</a>&nbsp;
        <a href="{{ route('loan_preview.index', compact('loan_id')) }}" class="btn btn-primary">Next</a>
    </div>
@endsection
