@extends('layouts.logged_in')

@section('title', 'Loan Application')

@section('heading', $user->name. ' / '. 'New Loan Application'. ' ['.  str_replace('_', ' ', $loan->loan_product_name) . ' - '. $loan->interval . ' ]')

@section('content')
    @include('partials._messages')
{{--    @include('partials._progress_bar')--}}
    <form class="mt-3" action="{{ route('terms.post') }}" method="POST">
        @csrf
        <input type="hidden" name="loan_id" value="{{ $loan_id }}">
        <div class="row">
            <div class="col-2"></div>
            <div class="col-6">
                <div class="mb-3 row">
                    <label for="loan_principle" class="col-sm-3 col-form-label">Loan Principle</label>
                    <div class="col-sm-9">
                        <input name="loan_principle" id="loan_principle" type="number"  class="form-control" value="{{ old('loan_principle', $loan->loan_amount ?? $loan_product->minPrincipal) }}" min="{{$loan_product->minPrincipal}}" max="{{$loan_product->maxPrincipal}}" >
                        <span>(Min: {{$loan_product->minPrincipal}}, Max: {{$loan_product->maxPrincipal}})</span>
                    </div>
                </div>
                <div class="mb-3 row">
                    <label for="loan_term" class="col-sm-3 col-form-label">Loan Period</label>
                    <div class="col-sm-9">
                        <input name="loan_term" id="loan_term" type="number" min="1" max="12" class="form-control" value="{{ old('loan_term', $loan->loan_term ?? '') }}" >
                    </div>
                </div>
{{--                <div class="mb-3 row">--}}
{{--                    <label for="loan_repayment" class="col-sm-3 col-form-label">Number of Repayments</label>--}}
{{--                    <div class="col-sm-9">--}}
{{--                        <input name="loan_repayment" id="loan_repayment" type="number" class="form-control" value="{{ old('loan_repayment', $loan->number_of_repayments ?? '') }}">--}}
{{--                    </div>--}}
{{--                </div>--}}
{{--                <div class="mb-3 row">--}}
{{--                    <label for="loan_repayment_frequency" class="col-sm-3 col-form-label">Repayment Every</label>--}}
{{--                    <div class="col-sm-9">--}}
{{--                        <input name="loan_repayment_frequency" id="loan_repayment_frequency" type="number" class="form-control" value="1" readonly>--}}
{{--                    </div>--}}
{{--                </div>--}}

                <div class="d-flex justify-content-end">
                    <a href="{{ route('loan_application.index') }}" class="btn btn-secondary">Cancel</a>&nbsp;
                    <button type="submit" class="btn btn-primary">Next</button>
                </div>

            </div>
            <div class="col"></div>
        </div>
    </form>
@endsection
