@extends('layouts.logged_in')

@section('title', 'Payment Agents')

@section('heading', 'Payment Agents')

@section('content')
    @include('partials._messages')

    @can('add-payment_agent', $user)
        <a class="btn btn-secondary" href="{{ route('payment_agent.create') }}">Add Payment Agent</a>
    @endcan

    <hr>
    <table class="table">
        <thead>
            <tr>
                <th>Agent</th>
                <th>Email</th>
                <th>Status</th>
                <th>Environment</th>
                <th>Created</th>
                <th></th>
            </tr>
        </thead>
        <tbody>
            @foreach ($payment_agents as $k => $P)
                <tr>
                    <td>{{ $P->name }}</td>
                    <td>{{ $P->email }}</td>
                    <td>
                        <span class="{{ $P->text_class($P->api_token_status) }}">
                            {{ $P->status($P->api_token_status) }}
                        </span>
                    </td>
                    <td> <span class="{{ $P->text_class($P->environment) }}">{{ $P->environment }}</span></td>
                    <td>{{ $P->created_at }}</td>
                    <td class="text-center">
                        @can('view-token', $user)
                            <button class="btn btn-info"
                                onclick="populate_modal('{{ $P->name }}','{{ $P->api_token ? $P->api_token : 'Token Missing' }}')"
                                data-bs-toggle="modal" data-bs-target="#exampleModal">View Token</button>
                        @endcan
                        <a class="btn btn-primary" href="{{ route('payment_agent.edit', $P->id) }}">Edit</a>
                        @can('delete-payment_agent', $user)
                            <form method="POST" style="display:inline;" action="{{ route('payment_agent.delete', $P->id) }}">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger"
                                    onclick="confirm('Are you sure you want to delete this item?')">Delete</button>
                            </form>
                        @endcan
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <!-- Modal -->
    <div class="modal fade " id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h3 class="modal-title" id="payment_agent"></h3>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-danger" role="alert">

                        <b><i data-feather="alert-triangle"></i> Warning</b> : This is confidential and should
                        only be shared with the payment agent.
                    </div>

                    <table class="table">
                        <tbody>
                            <tr>
                                <td>Header</td>
                                <td>Authorization</td>
                            </tr>
                            <tr>
                                <td>Token Type</td>
                                <td>Bearer</td>
                            </tr>
                            <tr>
                                <td>Url</td>
                                <td>{{ url('/') }}</td>
                            </tr>
                        </tbody>
                    </table>
                    <h5>Token</h5>
                    <span id="token"></span>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <script>
        function populate_modal(agent, token) {
            agent_ele = document.getElementById('payment_agent');
            token_ele = document.getElementById('token');

            agent_ele.textContent = agent;
            token_ele.textContent = token;
        }
    </script>
@endsection
