<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\PaymentAgentController;
use App\Http\Controllers\APITransactionController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\EbankingActivation;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\MyStatementController;
use App\Http\Controllers\LoanApplicationController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', [HomeController::class, 'index'])->name('home');

//Auth::routes();
Auth::routes([
    'register' => false // disable registration route
]);


Route::get('/account_number',[EbankingActivation::class,'account_number'])->name('account_number');
Route::post('/verify_account_number',[EbankingActivation::class,'verify_account_number'])->name('verify_account_number');
Route::get('/activate_account/{EbankingActivationRequest}',[EbankingActivation::class,'activate_account'])->name('activate_account');
Route::post('/create_account',[EbankingActivation::class,'create_account'])->name('create_account');
Route::post('/verify_otp',[EbankingActivation::class,'verify_otp'])->name('verify_otp');
Route::get('/send_otp/{EbankingActivationRequest}',[EbankingActivation::class,'send_otp'])->name('send_otp');


Route::middleware('auth')->group(function(){

    Route::get('/home', [HomeController::class, 'index'])->name('home');

    Route::get('/my_statement', [MyStatementController::class, 'index'])->name('my_statement.index');

    Route::get('/loan_application', [LoanApplicationController::class, 'index'])->name('loan_application.index');
    Route::get('/loan_application/create',[LoanApplicationController::class,'create'])->name('loan_application.create');
    Route::post('/loan_application/store',[LoanApplicationController::class,'store'])->name('loan_application.store');
    Route::put('/loan_application/approve/{loan}',[LoanApplicationController::class,'approve'])->name('loan_application.approve');
//    Route::put('/loan_application/reject/{loan}',[LoanApplicationController::class,'reject'])->name('loan_application.reject');


    Route::get('/loan_approval', [LoanApplicationController::class, 'loan_approval'])->name('loan_application.loan_approval');

    Route::get('/loan_charges_admin', [LoanApplicationController::class, 'loan_charges_admin'])->name('loan_application.loan_charges_admin');
    Route::get('/loan_charges_create', [LoanApplicationController::class, 'loan_charges_create'])->name('loan_application.loan_charges_create');
    Route::post('/loan_charges_store', [LoanApplicationController::class, 'loan_charges_store'])->name('loan_application.loan_charges_store');

    Route::get('/payment_agent',[PaymentAgentController::class,'index'])->name('payment_agent.index');
    Route::get('/payment_agent/create',[PaymentAgentController::class,'create'])->name('payment_agent.create');
    Route::post('/payment_agent/store',[PaymentAgentController::class,'store'])->name('payment_agent.store');
    Route::get('/payment_agent/{id}/edit',[PaymentAgentController::class,'edit'])->name('payment_agent.edit');
    Route::post('/payment_agent/update/{id}',[PaymentAgentController::class,'update'])->name('payment_agent.update');
    Route::delete('/payment_agent/{id}',[PaymentAgentController::class,'destroy'])->name('payment_agent.delete');

    Route::get('/APITransaction',[APITransactionController::class,'index'])->name('APITransaction.index');
    Route::get('/APITransaction/requeue_transaction/{id}',[APITransactionController::class,'requeue_transaction'])->name('APITransaction.requeue_transaction');


    Route::get('/dashboard',[DashboardController::class,'index'])->name('dashboard.index');

    Route::get('/user',[UserController::class,'index'])->name('user.index');
    // Route::get('/user/create',[UserController::class,'create'])->name('user.create');
    // Route::post('/user/store',[UserController::class,'store'])->name('user.store');
    Route::get('/user/{id}/edit',[UserController::class,'edit'])->name('user.edit');
    Route::post('/user/update/{id}',[UserController::class,'update'])->name('user.update');
    // Route::delete('/user/{id}',[UserController::class,'destroy'])->name('user.delete');


    Route::post('/product/create', [LoanApplicationController::class, 'product'])->name('product.create');

    Route::get('/terms/{loan_id}', [LoanApplicationController::class, 'terms'])->name('terms.index');
    Route::post('/terms', [LoanApplicationController::class, 'post_terms'])->name('terms.post');

    Route::get('/settings/{loan_id}', [LoanApplicationController::class, 'settings'])->name('settings.index');
    Route::post('/settings', [LoanApplicationController::class, 'post_settings'])->name('settings.post');

    Route::get('/charges/{loan_id}', [LoanApplicationController::class, 'charges'])->name('charges.index');

    Route::get('/collateral/{loan_id}', [LoanApplicationController::class, 'collateral'])->name('collateral.index');
    Route::post('/collateral', [LoanApplicationController::class, 'post_collateral'])->name('collateral.post');

    Route::get('/guarantor/{loan_id}', [LoanApplicationController::class, 'guarantor'])->name('guarantor.index');
    Route::post('/guarantor', [LoanApplicationController::class, 'post_guarantor'])->name('guarantor.post');

    Route::get('/repayment_schedule/{loan_id}', [LoanApplicationController::class, 'repayment_schedule'])->name('repayment_schedule.index');

    Route::get('/loan_preview/{loan_id}', [LoanApplicationController::class, 'loan_preview'])->name('loan_preview.index');

    Route::get('/search_customer/{searchTerm}', [LoanApplicationController::class, 'search_customer'])->name('search_customer');

});
