<?php $__env->startSection('title', 'Loan Application'); ?>

<?php $__env->startSection('heading', $user->name. ' / '. 'New Loan Application'. ' ['.  str_replace('_', ' ', $loan->loan_product_name) . ' - '. $loan->interval . ' ]'); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('partials._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <form action="<?php echo e(route('settings.post')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="loan_id" value="<?php echo e($loan_id); ?>">
        <div class="row">
            <div class="col-2"></div>
            <div class="col-6">
                <div class="mb-3 row">
                    <label for="loan_purpose"  class="col-sm-3 col-form-label">Loan Purpose</label>
                    <div class="col-sm-9">
                        <select name="loan_purpose" id="loan_purpose" class="form-control">
                            <option value="----------">Select</option>
                            <option value="working_capital_finance" <?php echo e(old('loan_purpose', $loan->loan_purpose ?? '') == 'working_capital_finance' ? 'selected' : ''); ?>>Working Capital Finance</option>
                            <option value="home_loan" <?php echo e(old('loan_purpose', $loan->loan_purpose ?? '') == 'home_loan' ? 'selected' : ''); ?>>Home Loan</option>
                            <option value="study_loan" <?php echo e(old('loan_purpose', $loan->loan_purpose ?? '') == 'study_loan' ? 'selected' : ''); ?>>Study Loan</option>
                            <option value="other_asset_acquisition" <?php echo e(old('loan_purpose', $loan->loan_purpose ?? '') == 'other_asset_acquisition' ? 'selected' : ''); ?>>Other Asset Acquisition</option>
                            <option value="project_finance" <?php echo e(old('loan_purpose', $loan->loan_purpose ?? '') == 'project_finance' ? 'selected' : ''); ?>>Project Finance</option>
                            <option value="equipment_and_machinery_finance" <?php echo e(old('loan_purpose', $loan->loan_purpose ?? '') == 'equipment_and_machinery_finance' ? 'selected' : ''); ?>>Equipment & Machinery Finance</option>
                            <option value="subscription_finance" <?php echo e(old('loan_purpose', $loan->loan_purpose ?? '') == 'subscription_finance' ? 'selected' : ''); ?>>Subscription Finance</option>
                            <option value="personal_finance" <?php echo e(old('loan_purpose', $loan->loan_purpose ?? '') == 'personal_finance' ? 'selected' : ''); ?>>Personal Finance</option>
                            <option value="finance_for_trading_in_securities" <?php echo e(old('loan_purpose', $loan->loan_purpose ?? '') == 'finance_for_trading_in_securities' ? 'selected' : ''); ?>>Finance for Trading in Securities</option>
                            <option value="consolidation_loan" <?php echo e(old('loan_purpose', $loan->loan_purpose ?? '') == 'consolidation_loan' ? 'selected' : ''); ?>>Consolidation loan</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                </div>
                <div class="mb-3 row">
                    <label for="loan_classification"  class="col-sm-3 col-form-label">Loan Classification</label>
                    <div class="col-sm-9">
                        <select name="loan_classification" id="loan_classification" class="form-control">
                            <option value="----------">Select</option>
                            <option value="agriculture_forestry_fishing" <?php echo e(old('loan_classification', $loan->loan_classification ?? '') == 'agriculture_forestry_fishing' ? 'selected' : ''); ?>>Agriculture, forestry & fishing</option>
                            <option value="commerce_trading_and_finance" <?php echo e(old('loan_classification', $loan->loan_classification ?? '') == 'commerce_trading_and_finance' ? 'selected' : ''); ?>>Commerce, trading & finance</option>
                            <option value="construction" <?php echo e(old('loan_classification', $loan->loan_classification ?? '') == 'construction' ? 'selected' : ''); ?>>Construction</option>
                            <option value="electricity_gas_water" <?php echo e(old('loan_classification', $loan->loan_classification ?? '') == 'electricity_gas_water' ? 'selected' : ''); ?>>Electricity, Gas & Water</option>
                            <option value="manufacturing" <?php echo e(old('loan_classification', $loan->loan_classification ?? '') == 'manufacturing' ? 'selected' : ''); ?>>Manufacturing</option>
                            <option value="miscellaneous" <?php echo e(old('loan_classification', $loan->loan_classification ?? '') == 'miscellaneous' ? 'selected' : ''); ?>>Miscellaneous</option>
                            <option value="services" <?php echo e(old('loan_classification', $loan->loan_classification ?? '') == 'services' ? 'selected' : ''); ?>>Services</option>
                            <option value="transport_storage_and_communication" <?php echo e(old('loan_classification', $loan->loan_classification ?? '') == 'transport_storage_and_communication' ? 'selected' : ''); ?>>Transport, storage and communication</option>
                            <option value="mining_quarrying" <?php echo e(old('loan_classification', $loan->loan_classification ?? '') == 'mining_quarrying' ? 'selected' : ''); ?>>Mining & Quarrying</option>
                        </select>
                    </div>
                </div>
                <div class="mb-3 row">
                    <label for="loan_savings_account" class="col-sm-3 col-form-label">Linked savings/current</label>
                    <div class="col-sm-9">
                        <input type="text" class="form-control" name="loan_savings_account" id="loan_savings_account" value="<?php echo e($user->account); ?>" readonly>
                    </div>






                </div>
                <div class="mb-3 row">
                    <label for="standing_instruction" class="col-sm-3 col-form-label">Create standing instructions at disbursement</label>
                    <div class="col-sm-9">
                        <select class="form-control" name="standing_instruction" id="standing_instruction">
                            <option value="1" selected>Yes</option>
                        </select>
                    </div>
                </div>
                <div class="mb-3 row">
                    <label for="top_up" class="col-sm-3 col-form-label">Is top-up?</label>
                    <div class="col-sm-9">
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="top_up" id="top_up1" value="1" <?php echo e(old('top_up', $loan->is_top_up ?? '') == '1' ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="top_up1">YES</label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input class="form-check-input" type="radio" name="top_up" id="top_up2" value="0" <?php echo e(old('top_up', $loan->is_top_up ?? '') == '0' ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="top_up2">NO</label>
                        </div>

                    </div>
                </div>
                <div class="mb-3 row">
                    <label for="first_repayment_date" class="col-sm-3 col-form-label">First Repayment On</label>
                    <div class="col-sm-9">
                        <input type="date" name="first_repayment_date" id="first_repayment_date" class="form-control"  value="<?php echo e($first_repayment_on); ?>" readonly>
                    </div>
                </div>

                <div class="d-flex justify-content-end">
                    <a href="<?php echo e(route('terms.index', compact('loan_id'))); ?>" class="btn btn-secondary">Previous</a>&nbsp;
                    <button type="submit" class="btn btn-primary">Next</button>
                </div>
            </div>
            <div class="col"></div>
        </div>
    </form>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.logged_in', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/portal.nzuritrust.com/public_html/Ebanqr-API/resources/views/loan_application/wizard/settings.blade.php ENDPATH**/ ?>