<?php $__env->startSection('title', 'Loan Application'); ?>

<?php $__env->startSection('heading', 'Loan Application'); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('partials._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('loan_application.dropdowns.products', ['data' => $data], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <hr>
    <table class="table">
        <thead>
        <tr>
            <th>Loan Amount Applied </th>
            <th>Loan Amount Approved</th>
            <th>Loan Period</th>
            <th>Loan Purpose</th>
            <th>Loan Product</th>
            <th>Status</th>
            <th></th>
        </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $loans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $loan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td class="text-end"><?php echo e(number_format($loan->loan_amount, 2, '.', ',')); ?></td>
                    <td class="text-end">
                        <?php
                            $approved_amount = null;
                            $loan_single = DB::table('loans')->where('id', $loan->id)->first();
                            $get_amount_approved = DB::table('approval_records')->where('loan_id' , $loan->id)->where('approval_level', $loan_single -> max_approval_level)->first();
                            if($get_amount_approved)
                            {
                                $approved_amount = $get_amount_approved->adjusted_amount;
                            }
                        ?>
                        <?php if(!is_null($approved_amount)): ?>
                        <?php echo e(number_format( $approved_amount,2, '.', ',')); ?>

                        <?php endif; ?>
                    </td>
                    <td><?php echo e($loan->interval); ?></td>
                    <td><?php echo e(ucfirst(str_replace('_', ' ', $loan->loan_purpose))); ?></td>
                    <td><?php echo e(ucfirst(str_replace('_', ' ', $loan->loan_product_name))); ?></td>
                    <td>
                        <span class="badge <?php if($loan->status == 'Approved'): ?> bg-success <?php elseif($loan->status == 'Rejected'): ?> bg-danger <?php else: ?> bg-warning  <?php endif; ?>"><?php echo e(ucfirst($loan->status)); ?></span>
                    </td>
                    <td>

                        <a class="btn btn-primary btn-sm" href="<?php echo e(route('terms.index', $loan->id)); ?>" role="button"><span class="glyphicon glyphicon-edit" aria-hidden="true"></span> Edit</a>
                        <a class="btn btn-danger btn-sm" href="" role="button"><span class="glyphicon glyphicon-edit" aria-hidden="true"></span> Delete</a>

                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.logged_in', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/portal.nzuritrust.com/public_html/Ebanqr-API/resources/views/loan_application/index.blade.php ENDPATH**/ ?>