<?php $__env->startSection('title', 'Loan Application'); ?>

<?php $__env->startSection('heading', $user->name. ' / '. 'New Loan Application'. ' ['.  str_replace('_', ' ', $loan->loan_product_name) . ' - '. $loan->interval . ' ]'); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('partials._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <table class="table">
        <thead>
        <tr>
            <th>#</th>
            <th>Date</th>
            <th>Principle Due</th>
            <th>Principle Balance</th>
            <th>Interest & Charges</th>
            <th>Out standing</th>
        </tr>
        </thead>
        <tbody>
        <!-- Loop through loan schedule data and display rows -->
        <?php $__currentLoopData = $loan_schedule; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $A): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($k + 1); ?></td>
                <td><?php echo e(\Carbon\Carbon::create($A['dueDate'][0], $A['dueDate'][1], $A['dueDate'][2])->format('d M Y')); ?></td>
                <td><?php echo e($currency); ?><?php echo e(isset($A['principalDue']) ? $A['principalDue'] : ''); ?></td>
                <td><?php echo e($currency); ?><?php echo e(isset($A['principalLoanBalanceOutstanding']) ? $A['principalLoanBalanceOutstanding'] : ''); ?></td>
                <td><?php echo e($currency); ?><?php echo e(isset($A['totalActualCostOfLoanForPeriod']) ? $A['totalActualCostOfLoanForPeriod'] : ''); ?></td>
                <td><?php echo e($currency); ?><?php echo e(isset($A['totalOutstandingForPeriod']) ? $A['totalOutstandingForPeriod'] : ''); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
        <tr>
            <td></td>
            <td><b>Total</b></td>
            <td><b><?php echo e($currency); ?><?php echo e($total_principle); ?></b></td>
            <td></td>
            <td><b><?php echo e($currency); ?><?php echo e($total_interests); ?></b></td>
            <td><b><?php echo e($currency); ?><?php echo e($expected_amount); ?></b></td>
        </tr>
    </table>
    <div class="d-flex justify-content-end">
        <a href="<?php echo e(route('guarantor.index', compact('loan_id'))); ?>" class="btn btn-secondary">Previous</a>&nbsp;
        <a href="<?php echo e(route('loan_preview.index', compact('loan_id'))); ?>" class="btn btn-primary">Next</a>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.logged_in', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/portal.nzuritrust.com/public_html/Ebanqr-API/resources/views/loan_application/wizard/schedule.blade.php ENDPATH**/ ?>