<?php $__env->startSection('title', 'Loan Application'); ?>

<?php $__env->startSection('heading', $user->name. ' / '. 'New Loan Application'. ' ['.  str_replace('_', ' ', $loan->loan_product_name) . ' - '. $loan->interval . ' ]'); ?>

<?php $__env->startSection('content'); ?>
    <?php echo $__env->make('partials._messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#collateral">
        Add Collateral
    </button>
    <button type="button" class="btn btn-danger">
        Delete All
    </button>
    <table class="table">
        <thead>
        <tr>
            <th>Type</th>
            <th>Value</th>
            <th>Description</th>
            <th>Actions</th>
        </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $collateral; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($result->collateral_name); ?></td>
                <td><?php echo e($result->value); ?></td>
                <td><?php echo e($result->description); ?></td>
                <td>
                    <button class="btn btn-primary">Edit</button>
                    <button class="btn btn-danger">Delete</button>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <div class="d-flex justify-content-end">
        <a href="<?php echo e(route('charges.index', compact('loan_id'))); ?>" class="btn btn-secondary">Previous</a>&nbsp;
        <a href="<?php echo e(route('guarantor.index', compact('loan_id'))); ?>" class="btn btn-primary">Next</a>
    </div>
<?php $__env->stopSection(); ?>

<div class="modal fade" id="collateral" tabindex="-1" aria-labelledby="collateralLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="collateralLabel">Select loan product</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form method="POST" action="<?php echo e(route('collateral.post')); ?>">
                <div class="modal-body">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="loan_id" value="<?php echo e($loan_id); ?>">
                        <div class="row">
                            <div class="col-2"></div>
                            <div class="col-8">
                                <div class="mb-3 row">
                                    <label for="collateral_type" class="col-sm-3 col-form-label">Collateral Type</label>
                                    <div class="col-sm-9">
                                        <input type="hidden" name="collateral_name" id="collateral_name" value="<?php echo e(isset($data->allowedCollateralTypes[0]) ? $data->allowedCollateralTypes[0]->name:''); ?> ">
                                        <select name="collateral_type" id="collateral_type" class="form-control">
                                            <?php $__currentLoopData = $data->allowedCollateralTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($result->id); ?>"><?php echo e($result->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                </div>
                                <div class="mb-3 row">
                                    <label for="collateral_value" class="col-sm-3 col-form-label">Value</label>
                                    <div class="col-sm-9">
                                        <input name="collateral_value" id="collateral_value" type="number" class="form-control">
                                    </div>
                                </div>
                                <div class="mb-3 row">
                                    <label for="collateral_description" class="col-sm-3 col-form-label">Description</label>
                                    <div class="col-sm-9">
                                        <textarea name="collateral_description" id="collateral_description" cols="30" rows="5" class="form-control"></textarea>
                                    </div>
                                </div>
                            </div>
                            <div class="col"></div>
                        </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        var hiddenField = document.getElementById('collateral_name');
        var dropdownField = document.getElementById('collateral_type');

        dropdownField.addEventListener('change', function() {
            var selectedOption = this.options[this.selectedIndex];
            var name = selectedOption.text;
            hiddenField.value = name;
        });
    });
</script>

<?php echo $__env->make('layouts.logged_in', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/vhosts/nzuritrust.com/portal.nzuritrust.com/Ebanqr-API/resources/views/loan_application/wizard/collateral.blade.php ENDPATH**/ ?>